# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from Menu_Callbacks import *
ON = False


def write_settings(self):
    # Frame for the Write Options
    self.fr_write = tk.Frame(self)
    self.fr_write.grid(row=0, column=4, rowspan=14, columnspan=2, padx=5, pady=5, sticky='w')
    self.fr_write.config(height=510, width=365, bd=5, highlightbackground="black", highlightthickness=1,
                         background='white')
    self.fr_write.grid_propagate(0)

    # Label for the Writing Options
    if sys.platform.startswith('darwin'):
        w_label = Label(self.fr_write, text='Writing Settings', font='systemSmallEmphasizedSystemFont', background='white')
    else:
        w_label = Label(self.fr_write, text='Writing Settings', font='Helvetica 10 bold', background='white')
    w_label.grid(row=0, column=0, sticky='w')

    # Vars variable for the Check Box
    self.w = StringVar()
    self.w.set(0)

    # Check Box for the 'Write from File' Option
    self.write_select = tk.Checkbutton(self.fr_write, background='white', text='Write From a File',
                                       variable=self.w, onvalue=1, offvalue=0, command=lambda: write_options(self),
                                       state=DISABLED)
    self.write_select.grid(row=1, column=0, sticky='w', pady=5, padx=5)
    self.write_select.config(activebackground="white", highlightcolor='white', background='white')

    # Label for the Check Box
    self.write_file_label = tk.Label(self.fr_write, text='Uploaded', background='white', fg='green', state=DISABLED)
    self.write_file_label.grid(row=1, column=1, padx=5, pady=5)
    self.write_file_label.grid_remove()

    if sys.platform.startswith('darwin'):
        self.write_select.config(font='systemSmallSystemFont')
        self.write_file_label.config(font='systemSmallSystemFont')
    else:
        self.write_select.config(font='Helvetica 10 bold')
    # Canvas for the Writing Options
    self.canvas = tk.Canvas(self.fr_write, bg='white', highlightbackground="white", bd=0, highlightthickness=0)
    self.canvas.grid(row=2, column=0, columnspan=3, rowspan=12, padx=5, pady=5, sticky='w')
    self.canvas.config(width=318, height=430, scrollregion=(0, 0, 1000, 1000))
    self.canvas.grid_propagate(0)

    # Inner Frame for the Writing Options
    self.fr_write_back = tk.Frame(self.canvas, bd=0, highlightthickness=0)
    self.fr_write_back.config(bg='white')
    self.canvas.create_window(2, 0, window=self.fr_write_back, anchor='nw')

    # Scrollbar for the Writing Options
    self.my_scrollbar = tk.Scrollbar(self.fr_write, orient='vertical')
    self.my_scrollbar.grid(row=2, column=10, sticky='ns', rowspan=12)
    self.canvas.config(yscrollcommand=self.my_scrollbar.set)
    self.my_scrollbar.config(command=self.canvas.yview)

    # Filling in the Writing Content
    increment = 0
    from File_Check import file_in_path
    from File_Check import config_file_format_check
    if not file_in_path(self, global_vars.id_file):
        if not config_file_format_check(self, global_vars.id_file):
            with open(global_vars.id_file, 'r') as file:  # Open the file
                for line in file.readlines():  # Read each line of the file
                    line = ((line.strip('\n')).split(':'))  # Remove white space and split
                    for x in range(len(line)):
                        line[x] = line[x].strip()
                    if line[0] != '' and line[0] != 'NV Region' and line[1] != '':
                        if not any(x in line[0] for x in global_vars.nv_multi_page_key_words):  # Non-Table Entry
                            line[0] = line[0].strip("*")  # Remove the (*) character

                            # Create the Label for the NV Region
                            w_name = tk.Label(self.fr_write_back, text=line[0], bg="white")
                            w_name.grid(row=increment, column=4, padx=5, pady=5, sticky='w')

                            # Create the Entry Option
                            et = tk.Entry(self.fr_write_back, relief=FLAT, bd=1)
                            et.grid(row=increment + 1, column=4, padx=5, sticky='w')
                            et.config(highlightbackground="grey", highlightthickness=1)

                            if sys.platform.startswith('darwin'):
                                w_name.config(font='systemSmallSystemFont')
                                et.config(width=33)
                            else:
                                w_name.config(font='Helvetica 9')
                                et.config(width=50)

                            # Increase the Increment Value
                            increment = increment + 2

    # Disable the Writing Option
    for x in self.fr_write_back.winfo_children():
        x.config(state=DISABLED)
    return
